/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.utils;

import com.pvsstudio.PvsPlugin;
import com.pvsstudio.rules.IssuesLoaderSensor;
import com.pvsstudio.utils.Version;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinReg;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Scanner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FilenameUtils;
import org.sonar.api.config.Configuration;
import org.sonar.api.utils.ManifestUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PvsUtils {
    private static final String OSValidator = System.getProperty("os.name").toLowerCase();
    public static final String UnsupportedSystemMessage = "Your OS is not supported!";
    private static final ArrayList<String> pvsStudioVersions = new ArrayList();
    private static PrintStream systemErr;

    public static List<String> execConsoleRequest(String[] args) {
        if (args == null || args.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        try {
            String line;
            Process launcher = Runtime.getRuntime().exec(args);
            launcher.waitFor();
            BufferedReader reader = new BufferedReader(new InputStreamReader(launcher.getInputStream()));
            while ((line = reader.readLine()) != null) {
                result.add(line);
            }
        }
        catch (IOException | InterruptedException e) {
            StringWriter stringWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stringWriter));
            IssuesLoaderSensor.LOGGER.error(e.toString() + " " + stringWriter.toString());
        }
        return result;
    }

    public static Version getMajorAndMinorVersion(String version, String util) {
        if (version == null) {
            return null;
        }
        Integer major = null;
        Integer minor = null;
        Scanner scanner = new Scanner(version.replace('.', ' '));
        if (!version.isEmpty()) {
            while (scanner.hasNext()) {
                if (scanner.hasNextInt() && major == null) {
                    major = scanner.nextInt();
                }
                if (scanner.hasNextInt() && minor == null) {
                    minor = scanner.nextInt();
                }
                if (major != null && minor != null) break;
                scanner.next();
            }
        }
        if (major == null || minor == null) {
            IssuesLoaderSensor.LOGGER.error("Can not get {} version.", (Object)util);
            return null;
        }
        return new Version(major, minor);
    }

    public static Version getVersion(List<String> resultRequest, String util) {
        if (resultRequest.size() != 1) {
            IssuesLoaderSensor.LOGGER.error("Can not get {} version.", (Object)util);
            return null;
        }
        return PvsUtils.getMajorAndMinorVersion(resultRequest.get(0), util);
    }

    public static boolean isCompatibleVersion(Version pvsStudio, Version pvsPlugin) {
        if (pvsStudio == null || pvsPlugin == null) {
            return false;
        }
        int pvsStudioMajorVersion = pvsStudio.major;
        int pvsStudioMinorVersion = pvsStudio.minor;
        int pvsPluginMajorVersion = pvsPlugin.major;
        int pvsPluginMinorVersion = pvsPlugin.minor;
        if (pvsStudioMajorVersion > pvsPluginMajorVersion || pvsStudioMajorVersion == pvsPluginMajorVersion && pvsStudioMinorVersion > pvsPluginMinorVersion) {
            IssuesLoaderSensor.LOGGER.warn("The PVS-Studio version " + pvsStudio + " is NEWER than PVS-Studio plugin version " + pvsPlugin + " for SonarQube..");
            return false;
        }
        if (pvsStudioMajorVersion < pvsPluginMajorVersion || pvsStudioMinorVersion < pvsPluginMinorVersion) {
            String pvsStudioStringVersion = pvsStudioMajorVersion + "." + String.format("%02d", pvsStudioMinorVersion);
            String pvsPluginStringVersion = pvsPluginMajorVersion + "." + String.format("%02d", pvsPluginMinorVersion);
            int pvsStudioVersionIndex = pvsStudioVersions.indexOf(pvsStudioStringVersion);
            int pvsPluginVersionIndex = pvsStudioVersions.indexOf(pvsPluginStringVersion);
            if (pvsStudioVersionIndex == -1 || pvsPluginVersionIndex == -1) {
                IssuesLoaderSensor.LOGGER.error("The PVS-Studio version " + pvsStudio + " is too old.");
                return false;
            }
            int countOfMinorCompatibleVersions = 10;
            if (pvsStudioVersionIndex - pvsPluginVersionIndex <= 9) {
                IssuesLoaderSensor.LOGGER.warn("The PVS-Studio version " + pvsStudio + " is newer than PVS-Studio Plugin version " + pvsPlugin + " for SonarQube");
                return true;
            }
            IssuesLoaderSensor.LOGGER.error("The PVS-Studio version " + pvsStudio + " is too old.");
            return false;
        }
        return true;
    }

    public static boolean pvsCompatibleVersions() {
        ArrayList<String> coreVersions = new ArrayList<String>();
        String executablePath = PvsUtils.getPvsStudioExecutablePath();
        if (executablePath != null) {
            coreVersions.addAll(PvsUtils.execConsoleRequest(new String[]{executablePath, "--version"}));
        } else {
            String javaLibraryPath = PvsUtils.getPvsStudioLibraryPath();
            if (javaLibraryPath != null) {
                coreVersions.add(Paths.get(javaLibraryPath, "../../..").normalize().getFileName().toString());
            }
        }
        Version pvsStudioVersion = PvsUtils.getVersion(coreVersions, "PVS-Studio");
        Version pvsPluginVersion = PvsUtils.getVersion(ManifestUtils.getPropertyValues((ClassLoader)PvsPlugin.class.getClassLoader(), (String)"Plugin-Version"), "PVS-Studio Plugin");
        return PvsUtils.isCompatibleVersion(pvsStudioVersion, pvsPluginVersion);
    }

    public static String getPvsStudioExecutablePath() {
        String pvsstudio = "";
        if (PvsUtils.isUnix() || PvsUtils.isMac()) {
            String[] paths;
            for (String path : paths = System.getenv("PATH").split(":")) {
                pvsstudio = path + "/pvs-studio";
                File file = new File(pvsstudio);
                if (!file.exists() || !file.isFile()) continue;
                return pvsstudio;
            }
            for (String path : paths) {
                pvsstudio = path + "/pvs-studio";
                IssuesLoaderSensor.LOGGER.debug("pvs-studio not found: {}", (Object)pvsstudio);
            }
        } else if (PvsUtils.isWindows()) {
            pvsstudio = PvsUtils.GetModuleDirectory() + File.separator + "x64" + File.separator + "PVS-Studio.exe";
            File file = new File(pvsstudio);
            if (file.exists() && file.isFile()) {
                return pvsstudio;
            }
            IssuesLoaderSensor.LOGGER.debug("PVS-Studio for C/C++/C# wasn't found: {}", (Object)pvsstudio);
        } else {
            IssuesLoaderSensor.LOGGER.error(UnsupportedSystemMessage);
        }
        return null;
    }

    public static String getPvsStudioLibraryPath() {
        String lastModifyFile;
        String homeDirectory = System.getenv(PvsUtils.isWindows() ? "AppData" : "HOME");
        if (homeDirectory == null || homeDirectory.isEmpty()) {
            IssuesLoaderSensor.LOGGER.debug("Home/AppData directory wasn't found.");
            return null;
        }
        File home = new File(homeDirectory = homeDirectory + File.separator + (PvsUtils.isWindows() ? "PVS-Studio-Java" : ".config/PVS-Studio-Java"));
        if (!home.exists() || !home.isDirectory()) {
            IssuesLoaderSensor.LOGGER.debug("Analyzer installation directory doesn't exist: {}.", (Object)homeDirectory);
            return null;
        }
        Path rp = home.toPath();
        try {
            String dllName = PvsUtils.isWindows() ? "analysis-core.dll" : (PvsUtils.isUnix() ? "libanalysis-core.so" : "libanalysis-core.dylib");
            List dllPaths = Files.walk(rp, Integer.MAX_VALUE, new FileVisitOption[0]).filter(p -> p.toFile().getAbsolutePath().endsWith(dllName) && !p.toFile().isDirectory()).map(Path::toFile).map(File::getAbsolutePath).collect(Collectors.toList());
            if (dllPaths.isEmpty()) {
                IssuesLoaderSensor.LOGGER.debug("PVS-Studio for Java wasn't found.");
                return null;
            }
            lastModifyFile = (String)dllPaths.get(dllPaths.size() - 1);
        }
        catch (Exception ex) {
            return null;
        }
        return lastModifyFile;
    }

    public static String getCorrectPath(String fileName, String baseDir) {
        if (fileName == null || baseDir == null) {
            return null;
        }
        try {
            File file;
            String homeDirectory;
            String path = fileName;
            String base = baseDir;
            if (PvsUtils.isUnix() && (homeDirectory = System.getenv("HOME")) != null && !homeDirectory.isEmpty()) {
                if (path.startsWith("~/")) {
                    path = Paths.get(homeDirectory, path.substring(2)).toString();
                }
                if (base.startsWith("~/")) {
                    base = Paths.get(homeDirectory, base.substring(2)).toString();
                }
            }
            if ((file = new File(path)).exists() && file.isFile()) {
                return file.getAbsolutePath();
            }
            path = base + File.separator + path;
            file = new File(path);
            if (file.exists() && file.isFile()) {
                return file.getAbsolutePath();
            }
            return null;
        }
        catch (Throwable e) {
            return null;
        }
    }

    public static String getSourceTreeRootFromSettings(String settingsPath, String baseDir) {
        if (PvsUtils.isWindows()) {
            String fixSettingsPath = PvsUtils.getCorrectPath(settingsPath, baseDir);
            if (fixSettingsPath == null) {
                IssuesLoaderSensor.LOGGER.debug("Settings file doesn't exist: {}", (Object)settingsPath);
                return null;
            }
            File settingsFile = new File(settingsPath);
            if (!settingsFile.exists() || !settingsFile.isFile()) {
                IssuesLoaderSensor.LOGGER.debug("Can't find the PVS-Studio Settings.xml file.");
                return null;
            }
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            try {
                Node nNode;
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                Document doc = dBuilder.parse(settingsFile);
                doc.getDocumentElement().normalize();
                NodeList nList = doc.getElementsByTagName("SourceTreeRoot");
                if (nList.getLength() > 0 && (nNode = nList.item(0)) != null && nNode.getNodeType() == 1) {
                    Element eElement = (Element)nNode;
                    if (!eElement.hasChildNodes() || eElement.getFirstChild() == null) {
                        IssuesLoaderSensor.LOGGER.debug("SourceTreeRoot is empty in Settings.xml file.");
                        return null;
                    }
                    return eElement.getFirstChild().getNodeValue();
                }
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static String getDefaultSettingsXmlPath() {
        if (!PvsUtils.isWindows()) {
            return null;
        }
        String homeDirectory = System.getenv("AppData");
        if (homeDirectory == null || homeDirectory.isEmpty()) {
            IssuesLoaderSensor.LOGGER.debug("AppData directory wasn't found.");
            return null;
        }
        String path = homeDirectory + File.separator + "PVS-Studio" + File.separator + "Settings.xml";
        File home = new File(path);
        if (home.exists() && home.isFile()) {
            return home.getAbsolutePath();
        }
        return null;
    }

    public static String getNodeValueByTagName(Document doc, String tagName) {
        Node node;
        String nodeValue = null;
        NodeList nList = doc.getElementsByTagName(tagName);
        if (nList.getLength() > 0 && (node = nList.item(0)).getNodeType() == 1 && node.hasChildNodes()) {
            nodeValue = node.getFirstChild().getNodeValue();
        }
        return nodeValue;
    }

    public static <T> Predicate<T> distinctByKey(Function<? super T, Object> keyExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    private static void suppressErr() {
        systemErr = System.err;
        PrintStream newErr = new PrintStream(new ByteArrayOutputStream());
        System.setErr(newErr);
    }

    private static void restoreErr() {
        System.setErr(systemErr);
    }

    private static String GetModuleDirectory() {
        String modulePath = "";
        String defaultPvsDirectory = System.getenv("ProgramFiles(x86)") + File.separator + "PVS-Studio";
        String javaVersion = System.getProperty("java.version");
        IssuesLoaderSensor.LOGGER.debug("Java version: {}", (Object)javaVersion);
        String registryPath = PvsUtils.getMachineLevelRegistryPath();
        try {
            PvsUtils.suppressErr();
            String pvsDirectory = Advapi32Util.registryGetStringValue(WinReg.HKEY_LOCAL_MACHINE, registryPath, "InstallDir");
            PvsUtils.restoreErr();
            modulePath = pvsDirectory == null || pvsDirectory.trim().isEmpty() ? defaultPvsDirectory : pvsDirectory;
        }
        catch (Win32Exception e) {
            e.printStackTrace();
            modulePath = defaultPvsDirectory;
        }
        return modulePath;
    }

    private static String getMachineLevelRegistryPath() {
        if (PvsUtils.is64BitOS().booleanValue()) {
            return "SOFTWARE\\Wow6432Node\\ProgramVerificationSystems\\PVS-Studio";
        }
        return "SOFTWARE\\ProgramVerificationSystems\\PVS-Studio";
    }

    private static Boolean is64BitOS() {
        Boolean is64Bit = System.getProperty("os.name").contains("Windows") ? Boolean.valueOf(System.getenv("ProgramFiles(x86)") != null) : Boolean.valueOf(System.getProperty("os.arch").indexOf("64") != -1);
        return is64Bit;
    }

    public static boolean isWindows() {
        return OSValidator.contains("win");
    }

    public static boolean isMac() {
        return OSValidator.contains("mac");
    }

    public static boolean isUnix() {
        return OSValidator.contains("nix") || OSValidator.contains("nux") || OSValidator.contains("aix");
    }

    public static boolean booleanPropertyIsSet(Configuration config, String key) {
        if (config == null || key == null || !config.hasKey(key)) {
            return false;
        }
        Optional o = config.get(key);
        return o.filter(s -> s.equalsIgnoreCase("active") || s.equalsIgnoreCase("true") || s.equalsIgnoreCase("yes")).isPresent();
    }

    public static String getExtension(String filename) {
        return FilenameUtils.getExtension(filename);
    }

    static {
        pvsStudioVersions.add("7.40");
        pvsStudioVersions.add("7.39");
        pvsStudioVersions.add("7.38");
        pvsStudioVersions.add("7.37");
        pvsStudioVersions.add("7.36");
        pvsStudioVersions.add("7.35");
        pvsStudioVersions.add("7.35");
        pvsStudioVersions.add("7.34");
        pvsStudioVersions.add("7.34");
        pvsStudioVersions.add("7.34");
        pvsStudioVersions.add("7.34");
        pvsStudioVersions.add("7.33");
        pvsStudioVersions.add("7.32");
        pvsStudioVersions.add("7.31");
        pvsStudioVersions.add("7.30");
        pvsStudioVersions.add("7.29");
        pvsStudioVersions.add("7.28");
        pvsStudioVersions.add("7.27");
        pvsStudioVersions.add("7.26");
        pvsStudioVersions.add("7.25");
        pvsStudioVersions.add("7.24");
        pvsStudioVersions.add("7.23");
        pvsStudioVersions.add("7.22");
        pvsStudioVersions.add("7.21");
        pvsStudioVersions.add("7.20");
        pvsStudioVersions.add("7.20");
        pvsStudioVersions.add("7.20");
        pvsStudioVersions.add("7.20");
        pvsStudioVersions.add("7.19");
        pvsStudioVersions.add("7.18");
        pvsStudioVersions.add("7.17");
        pvsStudioVersions.add("7.16");
        pvsStudioVersions.add("7.15");
        pvsStudioVersions.add("7.14");
        pvsStudioVersions.add("7.13");
        pvsStudioVersions.add("7.12");
        pvsStudioVersions.add("7.11");
        pvsStudioVersions.add("7.10");
        pvsStudioVersions.add("7.09");
        pvsStudioVersions.add("7.08");
        pvsStudioVersions.add("7.07");
        pvsStudioVersions.add("7.06");
        pvsStudioVersions.add("7.05");
        pvsStudioVersions.add("7.04");
        pvsStudioVersions.add("7.03");
        pvsStudioVersions.add("7.02");
        pvsStudioVersions.add("7.01");
        pvsStudioVersions.add("7.00");
        pvsStudioVersions.add("6.27");
        pvsStudioVersions.add("6.26");
        pvsStudioVersions.add("6.25");
        pvsStudioVersions.add("6.24");
        pvsStudioVersions.add("6.23");
        pvsStudioVersions.add("6.22");
        pvsStudioVersions.add("6.21");
        pvsStudioVersions.add("6.20");
        pvsStudioVersions.add("6.19");
        pvsStudioVersions.add("6.18");
        pvsStudioVersions.add("6.17");
        pvsStudioVersions.add("6.16");
        pvsStudioVersions.add("6.15");
        pvsStudioVersions.add("6.14");
        pvsStudioVersions.add("6.13");
        pvsStudioVersions.add("6.12");
        pvsStudioVersions.add("6.11");
        pvsStudioVersions.add("6.10");
        pvsStudioVersions.add("6.09");
        pvsStudioVersions.add("6.08");
        pvsStudioVersions.add("6.07");
        pvsStudioVersions.add("6.06");
        pvsStudioVersions.add("6.05");
        pvsStudioVersions.add("6.04");
        pvsStudioVersions.add("6.03");
        pvsStudioVersions.add("6.02");
        pvsStudioVersions.add("6.01");
        pvsStudioVersions.add("6.00");
    }
}

