/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.newsonarapi.rules;

import com.pvsstudio.utils.Message;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.rule.ActiveRules;
import org.sonar.api.batch.sensor.issue.NewIssue;
import org.sonar.api.config.Configuration;
import org.sonar.api.issue.impact.Severity;
import org.sonar.api.issue.impact.SoftwareQuality;
import org.sonar.api.utils.Version;

public class IssuesLoaderSensor
extends com.pvsstudio.rules.IssuesLoaderSensor {
    private static final Version LATEST_TESTED_VERSION_OF_SONARQUBE_PLUGIN_API = Version.parse((String)"11.2.0.2797");

    public IssuesLoaderSensor(Configuration config, FileSystem fileSystem, ActiveRules activeRules) {
        super(config, fileSystem, activeRules);
    }

    @Override
    protected Version getLastSupportedAndTestedSonarQubePluginAPI() {
        return LATEST_TESTED_VERSION_OF_SONARQUBE_PLUGIN_API;
    }

    @Override
    protected String getCurrentSonarQubeInfoMessage(Version currentSonarQubePluginApiVersion) {
        String sonarQubeEditionMessage = "Edition: " + this.context.runtime().getEdition();
        String sonarQubePluginAPIMessage = super.getSonarQubePluginAPIMessage(currentSonarQubePluginApiVersion);
        return sonarQubeEditionMessage + ", " + sonarQubePluginAPIMessage;
    }

    @Override
    public void setSeverityForPluginLoadedMessage(NewIssue newIssue, Message<?> message) {
        SoftwareQuality softwareQuality = message.isOWASPWarning() ? SoftwareQuality.SECURITY : SoftwareQuality.RELIABILITY;
        newIssue.overrideImpact(softwareQuality, IssuesLoaderSensor.getIssueImpactSeverityFromMessageLevel(message.getSeverity()));
        super.setSeverityForPluginLoadedMessage(newIssue, message);
    }

    @Override
    public void setSeverityForPluginGeneratedMessage(NewIssue newIssue, Message.MessageLevel messageLevel) {
        newIssue.overrideImpact(SoftwareQuality.RELIABILITY, IssuesLoaderSensor.getIssueImpactSeverityFromMessageLevel(messageLevel));
        super.setSeverityForPluginGeneratedMessage(newIssue, messageLevel);
    }

    public static Severity getIssueImpactSeverityFromMessageLevel(Message.MessageLevel reportMessageLevel) {
        switch (reportMessageLevel) {
            case Fails: {
                try {
                    return Enum.valueOf(Severity.class, "INFO");
                }
                catch (IllegalArgumentException ignored) {
                    return Severity.LOW;
                }
            }
            case High: {
                return Severity.HIGH;
            }
            case Medium: {
                return Severity.MEDIUM;
            }
            case Low: {
                return Severity.LOW;
            }
        }
        try {
            return Enum.valueOf(Severity.class, "BLOCKER");
        }
        catch (IllegalArgumentException ignored) {
            return Severity.HIGH;
        }
    }
}

