/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.utils;

import com.pvsstudio.rules.IssuesLoaderSensor;
import com.pvsstudio.utils.PvsUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class Message<T> {
    public static final String VTest = "VTEST";
    private static final Map<String, List<String>> LANGUAGE_TO_CODE = new HashMap<String, List<String>>(){
        {
            this.put("cs", new ArrayList<String>(){
                {
                    this.add(Message.VTest);
                    this.add("V5625");
                }
            });
        }
    };
    public static final String CWE_MARKER = "CWE-";
    public static final String MISRA_MARKER = "MISRA";
    public static final String OWASP_MARKER = "OWASP-";
    public static final String SourceTreeRootMarker = "|?|";
    protected static final String RENEW = "Renew";
    protected static final String UPDATE = "Update";
    public String falseAlarm;
    public String file;
    public int lineNumber;
    public String errorCode;
    public String message;
    public String level;
    public String cweCategory;
    public String misraCategory;
    public List<Integer> lineExtension;
    public List<Position> positions;
    protected boolean pvsDisplayMisra;
    protected boolean pvsDisplayCwe;
    private boolean isOWASPWarning;

    public static String getLanguageFromErrorCode_if_isSpecialDiagnostic(String errorCode, String defaultLanguage) {
        if (Message.isSpecialDiagnostic(errorCode)) {
            return Message.getLanguageFromSpecialDiagnosticErrorCode(errorCode);
        }
        return defaultLanguage;
    }

    protected static boolean isSpecialDiagnostic(String errorCode) {
        return LANGUAGE_TO_CODE.values().stream().flatMap(Collection::stream).anyMatch(e -> e.equals(errorCode));
    }

    private static String getLanguageFromSpecialDiagnosticErrorCode(String errorCode) {
        return LANGUAGE_TO_CODE.keySet().stream().filter(repoLang -> LANGUAGE_TO_CODE.get(repoLang).contains(errorCode)).findFirst().orElse("");
    }

    protected Message(boolean bCwe, boolean bMisra) {
        this.pvsDisplayMisra = bMisra;
        this.pvsDisplayCwe = bCwe;
    }

    protected static void logParserExceptions(Exception e) {
        IssuesLoaderSensor.LOGGER.error("An exception was thrown when parsing the PVS-Studio report. The report might contain incorrect syntax, or the report format is not supported at all. The supported report formats are '*.plog' or '*.json'.");
        if (IssuesLoaderSensor.LOGGER.isDebugEnabled()) {
            e.printStackTrace();
        }
    }

    protected static void logParsedMessages(List<? extends Message<?>> messages, long falseAlarmCount, long failWarningsCount) {
        IssuesLoaderSensor.LOGGER.info("Parsed messages: {}, Skipped FalseAlarms: {}, Unparsed messages: {}", new Object[]{(long)messages.size() + falseAlarmCount, falseAlarmCount, failWarningsCount});
        if ((long)messages.size() + falseAlarmCount == 0L && failWarningsCount > 0L) {
            throw new IllegalStateException("No messages were parsed!");
        }
    }

    protected static String formMessageFilePath(String filePath, String sourceTreeRoot, String baseDir) {
        if (filePath == null) {
            return null;
        }
        if (filePath.startsWith(SourceTreeRootMarker)) {
            if (sourceTreeRoot == null || sourceTreeRoot.trim().isEmpty()) {
                String newPath = filePath.replace(SourceTreeRootMarker, baseDir);
                File newFile = new File(newPath);
                if (!newFile.exists() || !newFile.isFile()) {
                    IssuesLoaderSensor.LOGGER.warn("No SourceTreeRoot was specified for: {}", (Object)filePath);
                    return null;
                }
                return newFile.getAbsolutePath();
            }
            return filePath.replace(SourceTreeRootMarker, sourceTreeRoot);
        }
        return filePath;
    }

    public abstract String getMessageForSonarQubeIssue(T var1);

    protected abstract List<Position> parsePositions(T var1, String var2, String var3);

    public String getIssueLoggerRepresentation(T obj) {
        return String.format("%s %s %s(%d)", this.level, this.getMessageForSonarQubeIssue(obj), this.getFilePath(), this.lineNumber);
    }

    public int getLine() {
        return this.lineNumber;
    }

    public List<Integer> getLineExtension() {
        return this.lineExtension;
    }

    public List<Position> getLinePositions() {
        return this.positions;
    }

    public String getType() {
        return this.errorCode;
    }

    public String getHash() {
        return this.errorCode + this.message + this.getFilePath() + this.lineNumber;
    }

    public String getDescription() {
        boolean misra;
        boolean cwe = this.pvsDisplayCwe && !this.cweCategory.isEmpty();
        boolean bl = misra = this.pvsDisplayMisra && !this.misraCategory.isEmpty();
        if (!cwe && !misra) {
            return this.message;
        }
        String result = "";
        if (cwe) {
            result = result + this.cweCategory;
        }
        if (misra) {
            result = result + (cwe ? ", " : "") + this.misraCategory;
        }
        return "[" + result + "] " + this.message;
    }

    public String toString() {
        return String.format("%s %s %s(%d)", this.level, this.message, this.getFilePath(), this.lineNumber);
    }

    public String getFilePath() {
        if (this.file == null || this.file.isEmpty()) {
            return "";
        }
        String ret = this.file;
        if (PvsUtils.isWindows()) {
            try {
                ret = new File(this.file).getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return ret;
    }

    public boolean isOWASPWarning() {
        return this.isOWASPWarning;
    }

    public void setIsOWASPWarning(boolean isOWASPWarning) {
        this.isOWASPWarning = isOWASPWarning;
    }

    public MessageLevel getSeverity() {
        switch (this.level) {
            case "0": {
                return MessageLevel.Fails;
            }
            case "1": {
                return MessageLevel.High;
            }
            case "2": {
                return MessageLevel.Medium;
            }
            case "3": {
                return MessageLevel.Low;
            }
        }
        return MessageLevel.Unknown;
    }

    public static class Position {
        public static final Character LINES_SEPARATOR = Character.valueOf(',');
        public final String file;
        public final List<Integer> linesNumbers;

        public Position(String filePath, List<Integer> lines) {
            this.file = filePath;
            this.linesNumbers = lines;
        }
    }

    public static enum MessageLevel {
        Unknown,
        Fails,
        High,
        Medium,
        Low;

    }
}

