/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.utils;

public enum AnalyzerType {
    General,
    Optimization,
    CustomerSpecific,
    Viva64,
    MISRA,
    AUTOSAR,
    OWASP,
    UNKNOWN;

    public static final int Viva64_CCpp_ErrorCode_Begin = 100;
    public static final int Viva64_CCpp_ErrorCode_End = 499;
    public static final int General_CCpp_Low_ErrorCode_Begin = 500;
    public static final int General_CCpp_Low_ErrorCode_End = 799;
    public static final int Optimization_CCpp_ErrorCode_Begin = 800;
    public static final int Optimization_CCpp_ErrorCode_End = 999;
    public static final int General_CCpp_High_ErrorCode_Begin = 1000;
    public static final int General_CCpp_High_ErrorCode_End = 1999;
    public static final int CustomerSpecific_CCpp_ErrorCode_Begin = 2000;
    public static final int CustomerSpecific_CCpp_ErrorCode_End = 2499;
    public static final int MISRA_CCpp_ErrorCode_Begin = 2500;
    public static final int MISRA_CCpp_ErrorCode_End = 2999;
    public static final int General_Cs_ErrorCode_Begin = 3000;
    public static final int General_Cs_ErrorCode_End = 3499;
    public static final int AUTOSAR_CCpp_ErrorCode_Begin = 3500;
    public static final int AUTOSAR_CCpp_ErrorCode_End = 3999;
    public static final int OWASP_CCpp_ErrorCode_Begin = 5000;
    public static final int OWASP_CCpp_ErrorCode_End = 5299;
    public static final int OWASP_Java_ErrorCode_Begin = 5300;
    public static final int OWASP_Java_ErrorCode_End = 5599;
    public static final int OWASP_Cs_ErrorCode_Begin = 5600;
    public static final int OWASP_Cs_ErrorCode_End = 5999;
    public static final int General_Java_ErrorCode_Begin = 6000;
    public static final int General_Java_ErrorCode_End = 6499;

    public static AnalyzerType GetAnalyzerType(String errorCodeStr) {
        block15: {
            if (errorCodeStr == null || errorCodeStr.length() <= 1) {
                return UNKNOWN;
            }
            try {
                String sub = errorCodeStr.substring(1);
                int errorCode = Integer.parseInt(sub);
                if (errorCode >= 100 && errorCode <= 499) {
                    return Viva64;
                }
                if (errorCode >= 500 && errorCode <= 799) {
                    return General;
                }
                if (errorCode >= 800 && errorCode <= 999) {
                    return Optimization;
                }
                if (errorCode >= 1000 && errorCode <= 1999) {
                    return General;
                }
                if (errorCode >= 2000 && errorCode <= 2499) {
                    return CustomerSpecific;
                }
                if (errorCode >= 2500 && errorCode <= 2999) {
                    return MISRA;
                }
                if (errorCode >= 3000 && errorCode <= 3499) {
                    return General;
                }
                if (errorCode >= 3500 && errorCode <= 3999) {
                    return AUTOSAR;
                }
                if (errorCode >= 5000 && errorCode <= 5299) {
                    return OWASP;
                }
                if (errorCode >= 5300 && errorCode <= 5599) {
                    return OWASP;
                }
                if (errorCode >= 5600 && errorCode <= 5999) {
                    return OWASP;
                }
                if (errorCode >= 6000 && errorCode <= 6499) {
                    return General;
                }
            }
            catch (Exception ex) {
                if (!errorCodeStr.equalsIgnoreCase("External")) break block15;
                return General;
            }
        }
        return UNKNOWN;
    }
}

