/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio.utils;

import com.pvsstudio.rules.IssuesLoaderSensor;
import com.pvsstudio.utils.Message;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonMessage
extends Message<JSONObject> {
    public JsonMessage(boolean bCwe, boolean bMisra) {
        super(bCwe, bMisra);
    }

    @Override
    public String getMessageForSonarQubeIssue(JSONObject warn) {
        return this.errorCode + ": " + warn.getString("message");
    }

    public static List<JsonMessage> GetMessagesFromReport(File report, String baseDir, String sourceTreeRoot, boolean pvsDisplayCwe, boolean pvsDisplayMisra) {
        String jsonFile = "";
        String reportPath = report.getAbsolutePath();
        try {
            jsonFile = new String(Files.readAllBytes(Paths.get(reportPath, new String[0])), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            IssuesLoaderSensor.LOGGER.error("Can't read Report file: {}", (Object)reportPath);
        }
        IssuesLoaderSensor.LOGGER.info("Reading PVS-Studio Report: {}", (Object)reportPath);
        ArrayList<JsonMessage> jsonMessages = new ArrayList<JsonMessage>();
        long failWarningsCount = 0L;
        long falseAlarmCount = 0L;
        try {
            JSONObject jsonDoc = new JSONObject(jsonFile);
            JSONArray warnings = jsonDoc.getJSONArray("warnings");
            for (int i = 0; i < warnings.length(); ++i) {
                JsonMessage msg = new JsonMessage(pvsDisplayCwe, pvsDisplayMisra);
                JSONObject warn = (JSONObject)warnings.get(i);
                msg.errorCode = warn.getString("code");
                if ("Renew".equalsIgnoreCase(msg.errorCode) || "Update".equalsIgnoreCase(msg.errorCode)) {
                    IssuesLoaderSensor.LOGGER.debug(msg.errorCode + " message from file {} is skipped.", (Object)report.getAbsolutePath());
                    continue;
                }
                if (!msg.errorCode.startsWith("V")) {
                    ++failWarningsCount;
                    continue;
                }
                boolean falseAlarm = warn.getBoolean("falseAlarm");
                if (falseAlarm) {
                    ++falseAlarmCount;
                    continue;
                }
                try {
                    int cweNumber = warn.getInt("cwe");
                    msg.cweCategory = cweNumber == 0 ? "" : "CWE-" + cweNumber;
                }
                catch (Exception e) {
                    msg.cweCategory = "";
                }
                try {
                    msg.misraCategory = warn.getString("sastId");
                    msg.setIsOWASPWarning(msg.misraCategory.startsWith("OWASP-"));
                    if (!msg.misraCategory.startsWith("MISRA")) {
                        msg.misraCategory = "";
                    }
                }
                catch (Exception e) {
                    msg.misraCategory = "";
                }
                msg.falseAlarm = "false";
                JSONArray positions = warn.getJSONArray("positions");
                JSONObject pos = (JSONObject)positions.get(0);
                msg.file = "";
                try {
                    msg.file = JsonMessage.formMessageFilePath(pos.getString("file"), sourceTreeRoot, baseDir);
                }
                catch (Exception e) {
                    ++failWarningsCount;
                    continue;
                }
                msg.message = msg.getMessageForSonarQubeIssue(warn);
                msg.level = String.valueOf(warn.getInt("level"));
                if (msg.file.isEmpty()) {
                    IssuesLoaderSensor.LOGGER.warn("Source code file not found: {}", (Object)msg.getIssueLoggerRepresentation(warn));
                    continue;
                }
                try {
                    msg.lineNumber = pos.getInt("line");
                }
                catch (JSONException e) {
                    IssuesLoaderSensor.LOGGER.warn("[msg.lineNumber] JSONException in: {}", (Object)msg.toString());
                    ++failWarningsCount;
                    continue;
                }
                if (msg.lineNumber <= 0) {
                    IssuesLoaderSensor.LOGGER.warn("Not positive LineNumber found: {}", (Object)msg.toString());
                    ++failWarningsCount;
                    continue;
                }
                msg.lineExtension = new ArrayList();
                msg.positions = msg.parsePositions(warn, sourceTreeRoot, baseDir);
                jsonMessages.add(msg);
            }
        }
        catch (JSONException e) {
            JsonMessage.logParserExceptions(e);
        }
        JsonMessage.logParsedMessages(jsonMessages, falseAlarmCount, failWarningsCount);
        return jsonMessages;
    }

    @Override
    protected List<Message.Position> parsePositions(JSONObject warning, String sourceTreeRoot, String baseDir) {
        ArrayList<Message.Position> result = new ArrayList<Message.Position>();
        ArrayList<Integer> line = new ArrayList<Integer>();
        String previousFilePath = "";
        try {
            JSONArray positions = warning.getJSONArray("positions");
            for (int i = 0; i < positions.length(); ++i) {
                String filePath;
                JSONObject pos = (JSONObject)positions.get(i);
                try {
                    filePath = pos.getString("file");
                }
                catch (Exception e) {
                    IssuesLoaderSensor.LOGGER.debug("Can not parse path to file");
                    continue;
                }
                filePath = JsonMessage.formMessageFilePath(filePath, sourceTreeRoot, baseDir);
                if (filePath == null) continue;
                if (!previousFilePath.equals("") && !filePath.equals(previousFilePath)) {
                    result.add(new Message.Position(previousFilePath, line));
                    line = new ArrayList();
                }
                line.add(pos.getInt("line"));
                previousFilePath = filePath;
            }
            result.add(new Message.Position(previousFilePath, line));
        }
        catch (Exception e) {
            IssuesLoaderSensor.LOGGER.debug("Can not parse position");
        }
        return result;
    }
}

